// Setup vars
var automatorwp_youtube_videos = {};
var automatorwp_youtube_triggers = {};

function onYouTubeIframeAPIReady() {

    // Get all video players on page
    var players = document.querySelectorAll( '.automatorwp-youtube-video' );

    for (var i = 0; i < players.length; i++ ) {

        var player = players[i];

        automatorwp_youtube_triggers[player.getAttribute( 'data-id' )] = player.getAttribute( 'data-trigger' );

        var iframe = new YT.Player( player, {
            videoId: player.getAttribute( 'data-id' ),
            height: player.getAttribute( 'data-height' ),
            width: player.getAttribute( 'data-width' ),
            playerVars: {
                'autoplay': ( player.getAttribute( 'data-autoplay' ) === 'yes' ? 1 : 0 ),
                'controls': ( player.getAttribute( 'data-controls' ) === 'yes' ? 1 : 0 )
            },
            events : {
                'onStateChange': 'automatorwp_youtube_video_change'
            }
        } );

    }

}

function automatorwp_youtube_video_change( event ) {

    var $ = $ || jQuery;

    var data = event.target.getVideoData();
    var id = data.video_id;
    var trigger = automatorwp_youtube_triggers[id];
    var duration = event.target.getDuration();
    var state = event.data;

    // Initialize video object
    if( automatorwp_youtube_videos[id] === undefined ) {

        automatorwp_youtube_videos[id] = {
            trigger: trigger,
            state: state,
            last_state: state,
            seconds: 0,
            duration: Math.floor( duration ),
            interval: undefined
        };

        // Start interval
        automatorwp_youtube_videos[id].interval = setInterval( function() {

            if( automatorwp_youtube_videos[id].last_state === YT.PlayerState.PLAYING )
                automatorwp_youtube_videos[id].seconds++;

            // Update last state
            automatorwp_youtube_videos[id].last_state = automatorwp_youtube_videos[id].state;
        }, 1000 );

    }

    // Update the video state
    automatorwp_youtube_videos[id].state = state;

    if( state === YT.PlayerState.PLAYING ) {
        // Play

    } else if( state === YT.PlayerState.PAUSED ) {
        // Pause

        // Clear the interval
        //clearInterval( automatorwp_youtube_videos[id].interval );

    } else if( state === YT.PlayerState.ENDED ) {
        // End

        // Add an extra second to watched seconds to avoid any delay issue
        if( automatorwp_youtube_videos[id].seconds < automatorwp_youtube_videos[id].duration
            && ( automatorwp_youtube_videos[id].seconds + automatorwp_youtube.allowed_delay ) >= automatorwp_youtube_videos[id].duration ) {
            automatorwp_youtube_videos[id].seconds += automatorwp_youtube.allowed_delay;
        }

        // Update last state
        automatorwp_youtube_videos[id].last_state = automatorwp_youtube_videos[id].state;

        // Check if user has seen the video
        if( automatorwp_youtube_videos[id].seconds >= automatorwp_youtube_videos[id].duration ) {

            jQuery.ajax({
                url: automatorwp_youtube.ajaxurl,
                type: 'POST',
                data: {
                    action: 'automatorwp_youtube_track_watch_video',
                    nonce: automatorwp_youtube.nonce,
                    trigger: automatorwp_youtube_videos[id].trigger,
                    video_id: id,
                    seconds: automatorwp_youtube_videos[id].seconds,
                    duration: automatorwp_youtube_videos[id].duration,
                    user_id: automatorwp_youtube.user_id,
                    post_id: automatorwp_youtube.post_id
                },
                success: function(response) {

                }
            }).fail( function (response) {

            });

        }

        // Clear the interval and reset seconds played
        clearInterval( automatorwp_youtube_videos[id].interval );

        // Remove the video from the array to let the script start again
        delete automatorwp_youtube_videos[id];

    }

}